package nemosofts.voxradio.adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.core.content.ContextCompat;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.material.ImageHelperView;
import androidx.nemosofts.theme.ColorUtils;
import androidx.recyclerview.widget.RecyclerView;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.nativeAds.MaxNativeAdListener;
import com.applovin.mediation.nativeAds.MaxNativeAdLoader;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.squareup.picasso.Picasso;
import com.startapp.sdk.ads.nativead.NativeAdDetails;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;

public class AdapterEpisodeList extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private final Context context;
    private List<ItemRadio> arrayList;
    private final List<ItemRadio> filteredArrayList;
    private final RecyclerItemClickListener listener;
    private NameFilter filter;
    private static final int VIEW_PROG = -1;

    Boolean isAdLoaded = false;
    List<NativeAd> mNativeAdsAdmob = new ArrayList<>();
    List<NativeAdDetails> nativeAdsStartApp = new ArrayList<>();

    public AdapterEpisodeList(Context context, List<ItemRadio> arrayList, RecyclerItemClickListener clickListener) {
        this.arrayList = arrayList;
        this.filteredArrayList = arrayList;
        this.context = context;
        this.listener = clickListener;
    }

    public static class MyViewHolder extends RecyclerView.ViewHolder {

        private final RelativeLayout relativeLayout;
        private final ImageHelperView poster;
        private final TextView title;
        private final TextView catName;
        private final ImageView play;
        private final RelativeLayout nativeAd;

        MyViewHolder(View view) {
            super(view);
            relativeLayout = view.findViewById(R.id.rl_podcasts_list);
            poster = view.findViewById(R.id.iv_podcasts_list);
            title = view.findViewById(R.id.tv_podcasts_list_name);
            catName = view.findViewById(R.id.tv_podcasts_list_cat);
            play = view.findViewById(R.id.iv_podcasts_play);
            nativeAd = view.findViewById(R.id.rl_native_ad);
        }
    }

    private static class ProgressViewHolder extends RecyclerView.ViewHolder {
        private ProgressViewHolder(View v) {
            super(v);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == VIEW_PROG) {
            View v = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.row_progressbar, parent, false);
            return new ProgressViewHolder(v);
        } else {
            View itemView = LayoutInflater.from(parent.getContext())
                    .inflate(R.layout.item_row_podcasts_vertical, parent, false);
            return new MyViewHolder(itemView);
        }
    }

    @OptIn(markerClass = UnstableApi.class)
    @Override
    public void onBindViewHolder(@NonNull final RecyclerView.ViewHolder holder, final int position) {
        if (holder instanceof MyViewHolder myViewHolder) {

            myViewHolder.title.setText(arrayList.get(position).getRadioTitle());
            myViewHolder.catName.setText(arrayList.get(position).getCategoryName());

            Picasso.get()
                    .load(arrayList.get(position).getImage())
                    .placeholder(R.drawable.material_design_default)
                    .error(R.drawable.material_design_default)
                    .into(myViewHolder.poster);

            if (PlayerService.getIsPlaying() && Callback.getPlayPos() <= holder.getAbsoluteAdapterPosition()
                    && Callback.getArrayListPlay().get(Callback.getPlayPos()).getId().equals(arrayList.get(position).getId())
                    && !Callback.getIsRadio()) {
                myViewHolder.play.setImageResource(R.drawable.ic_pause);
                myViewHolder.relativeLayout.setBackgroundColor(ColorUtils.colorPrimarySub(context));
            } else {
                myViewHolder.play.setImageResource(R.drawable.ic_play);
                myViewHolder.relativeLayout.setBackgroundColor(ContextCompat.getColor(context, android.R.color.transparent));
            }

            int step = 1;
            for (int i = 1; i < position + 1; i++) {
                step++;
                if (step > 7) {
                    step = 1;
                }
            }
            switch (step) {
                case 2 :
                    myViewHolder.play.setBackgroundTintList(ColorStateList
                            .valueOf(ContextCompat.getColor(context, R.color.color_setting_2)));
                    break;
                case 3 :
                    myViewHolder.play.setBackgroundTintList(ColorStateList
                            .valueOf(ContextCompat.getColor(context, R.color.color_setting_3)));
                    break;
                case 4 :
                    myViewHolder.play.setBackgroundTintList(ColorStateList
                            .valueOf(ContextCompat.getColor(context, R.color.color_setting_4)));
                    break;
                case 5 :
                    myViewHolder.play.setBackgroundTintList(ColorStateList
                            .valueOf(ContextCompat.getColor(context, R.color.color_setting_5)));
                    break;
                case 6 :
                    myViewHolder.play.setBackgroundTintList(ColorStateList
                            .valueOf(ContextCompat.getColor(context, R.color.color_setting_6)));
                    break;
                case 7 :
                    myViewHolder.play.setBackgroundTintList(ColorStateList
                            .valueOf(ContextCompat.getColor(context, R.color.color_setting_7)));
                    break;
                default :
                    myViewHolder.play.setBackgroundTintList(ColorStateList
                            .valueOf(ContextCompat.getColor(context, R.color.color_setting_1)));
                    break;
            }

            myViewHolder.relativeLayout.setOnClickListener(view -> listener.onClick(getPosition(
                    arrayList.get(holder.getAbsoluteAdapterPosition()).getId()))
            );

            if (Callback.getIsAdsStatus() && isAdLoaded
                    && (holder.getAbsoluteAdapterPosition() != arrayList.size() - 1)
                    && (holder.getAbsoluteAdapterPosition() + 1) % Callback.getNativeAdShow() == 0) {
                try {
                    if (myViewHolder.nativeAd.getChildCount() == 0) {
                        switch (Callback.getAdNetwork()) {
                            case Callback.AD_TYPE_ADMOB, Callback.AD_TYPE_META -> {
                                if (!mNativeAdsAdmob.isEmpty()) {

                                    int i = ApplicationUtil.getRandomValue(mNativeAdsAdmob.size() - 1);

                                    @SuppressLint("InflateParams") NativeAdView adView = (NativeAdView) ((Activity) context)
                                            .getLayoutInflater().inflate(R.layout.layout_native_ad_admob, null);
                                    populateUnifiedNativeAdView(mNativeAdsAdmob.get(i), adView);
                                    myViewHolder.nativeAd.removeAllViews();
                                    myViewHolder.nativeAd.addView(adView);

                                    myViewHolder.nativeAd.setVisibility(View.VISIBLE);
                                }
                            }
                            case Callback.AD_TYPE_STARTAPP -> {
                                int i = ApplicationUtil.getRandomValue(nativeAdsStartApp.size() - 1);
                                @SuppressLint("InflateParams") RelativeLayout nativeAdView = (RelativeLayout) ((Activity) context)
                                        .getLayoutInflater().inflate(R.layout.layout_native_ad_startapp, null);
                                populateStartAppNativeAdView(nativeAdsStartApp.get(i), nativeAdView);
                                myViewHolder.nativeAd.removeAllViews();
                                myViewHolder.nativeAd.addView(nativeAdView);
                                myViewHolder.nativeAd.setVisibility(View.VISIBLE);
                            }
                            case Callback.AD_TYPE_APPLOVIN -> {
                                MaxNativeAdLoader nativeAdLoader = getMaxNativeAdLoader(myViewHolder);
                                nativeAdLoader.loadAd();
                            }
                            default -> myViewHolder.nativeAd.setVisibility(View.GONE);
                        }
                    }
                } catch (Exception e) {
                    Log.e("AdapterEpisodeList","Error onBindViewHolder" ,e);
                }
            }
        }
    }

    @NonNull
    private MaxNativeAdLoader getMaxNativeAdLoader(MyViewHolder holder) {
        MaxNativeAdLoader nativeAdLoader = new MaxNativeAdLoader(Callback.getApplovinNativeAdID(), context);
        nativeAdLoader.setNativeAdListener(new MaxNativeAdListener() {
            @Override
            public void onNativeAdLoaded(final MaxNativeAdView nativeAdView, @NonNull final MaxAd ad) {
                holder.nativeAd.removeAllViews();
                holder.nativeAd.addView(nativeAdView);
                holder.nativeAd.setVisibility(View.VISIBLE);
            }
        });
        return nativeAdLoader;
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        if (arrayList.get(position) != null) {
            return position;
        } else {
            return VIEW_PROG;
        }
    }

    private int getPosition(String id) {
        int count = 0;
        for (int i = 0; i < filteredArrayList.size(); i++) {
            if (id.equals(filteredArrayList.get(i).getId())) {
                count = i;
                break;
            }
        }
        return count;
    }

    public Filter getFilter() {
        if (filter == null) {
            filter = new NameFilter();
        }
        return filter;
    }

    private class NameFilter extends Filter {

        @Override
        protected FilterResults performFiltering(CharSequence constraint) {

            constraint = constraint.toString().toLowerCase();
            FilterResults result = new FilterResults();
            if (!constraint.toString().isEmpty()) {
                ArrayList<ItemRadio> filteredItems = new ArrayList<>();

                for (int i = 0, l = filteredArrayList.size(); i < l; i++) {
                    String nameList = filteredArrayList.get(i).getRadioTitle();
                    if (nameList.toLowerCase().contains(constraint))
                        filteredItems.add(filteredArrayList.get(i));
                }
                result.count = filteredItems.size();
                result.values = filteredItems;
            } else {
                synchronized (this) {
                    result.values = filteredArrayList;
                    result.count = filteredArrayList.size();
                }
            }
            return result;
        }

        @SuppressLint("NotifyDataSetChanged")
        @SuppressWarnings("unchecked")
        @Override
        protected void publishResults(CharSequence constraint, FilterResults results) {
            arrayList = (ArrayList<ItemRadio>) results.values;
            notifyDataSetChanged();
        }
    }

    public void addAds(NativeAd unifiedNativeAd) {
        mNativeAdsAdmob.add(unifiedNativeAd);
        isAdLoaded = true;
    }

    public void addNativeAds(List<NativeAdDetails> nativeAdDetails) {
        nativeAdsStartApp.addAll(nativeAdDetails);
        isAdLoaded = true;
    }

    public void setNativeAds(boolean isLoaded) {
        isAdLoaded = isLoaded;
    }

    private void populateStartAppNativeAdView(NativeAdDetails nativeAdDetails, RelativeLayout nativeAdView) {
        ImageView icon = nativeAdView.findViewById(R.id.icon);
        TextView title = nativeAdView.findViewById(R.id.title);
        TextView description = nativeAdView.findViewById(R.id.description);
        Button button = nativeAdView.findViewById(R.id.button);

        icon.setImageBitmap(nativeAdDetails.getImageBitmap());
        title.setText(nativeAdDetails.getTitle());
        description.setText(nativeAdDetails.getDescription());
        button.setText(nativeAdDetails.isApp() ? "Install" : "Open");
    }

    private void populateUnifiedNativeAdView(NativeAd nativeAd, NativeAdView adView) {
        MediaView mediaView = adView.findViewById(R.id.ad_media);
        adView.setMediaView(mediaView);

        // Set other ad assets.
        adView.setHeadlineView(adView.findViewById(R.id.ad_headline));
        adView.setBodyView(adView.findViewById(R.id.ad_body));
        adView.setCallToActionView(adView.findViewById(R.id.ad_call_to_action));
        adView.setIconView(adView.findViewById(R.id.ad_icon));
        adView.setPriceView(adView.findViewById(R.id.ad_price));
        adView.setStarRatingView(adView.findViewById(R.id.ad_stars));
        adView.setStoreView(adView.findViewById(R.id.ad_store));
        adView.setAdvertiserView(adView.findViewById(R.id.ad_advertiser));

        // The headline is guaranteed to be in every UnifiedNativeAd.
        ((TextView) Objects.requireNonNull(adView.getHeadlineView())).setText(nativeAd.getHeadline());

        // These assets aren't guaranteed to be in every UnifiedNativeAd, so it's important to
        // check before trying to display them.
        if (nativeAd.getBody() == null) {
            Objects.requireNonNull(adView.getBodyView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getBodyView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getBodyView()).setText(nativeAd.getBody());
        }

        if (nativeAd.getCallToAction() == null) {
            Objects.requireNonNull(adView.getCallToActionView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getCallToActionView()).setVisibility(View.VISIBLE);
            ((Button) adView.getCallToActionView()).setText(nativeAd.getCallToAction());
        }

        if (nativeAd.getIcon() == null) {
            Objects.requireNonNull(adView.getIconView()).setVisibility(View.GONE);
        } else {
            ((ImageView) Objects.requireNonNull(adView.getIconView())).setImageDrawable(
                    nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getPrice() == null) {
            Objects.requireNonNull(adView.getPriceView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getPriceView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getPriceView()).setText(nativeAd.getPrice());
        }

        if (nativeAd.getStore() == null) {
            Objects.requireNonNull(adView.getStoreView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getStoreView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getStoreView()).setText(nativeAd.getStore());
        }

        if (nativeAd.getStarRating() == null) {
            Objects.requireNonNull(adView.getStarRatingView()).setVisibility(View.INVISIBLE);
        } else {
            ((RatingBar) Objects.requireNonNull(adView.getStarRatingView()))
                    .setRating(nativeAd.getStarRating().floatValue());
            adView.getStarRatingView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getAdvertiser() == null) {
            Objects.requireNonNull(adView.getAdvertiserView()).setVisibility(View.INVISIBLE);
        } else {
            ((TextView) Objects.requireNonNull(adView.getAdvertiserView())).setText(nativeAd.getAdvertiser());
            adView.getAdvertiserView().setVisibility(View.VISIBLE);
        }

        // This method tells the Google Mobile Ads SDK that you have finished populating your
        // native ad view with this native ad. The SDK will populate the adView's MediaView
        // with the media content from this native ad.
        adView.setNativeAd(nativeAd);
    }

    public interface RecyclerItemClickListener{
        void onClick(int position);
    }
}